<?php
$teamQuery = new WP_Query( [
    'post_type' => 'team',
    'order' => 'ASC',
    'orderby' => 'menu_order'
] );
?>

<?php if( $teamQuery->have_posts() ): ?>
    <section class="mil-cta mil-up mil-p-0-80">
        <div class="container">
            <div class="mil-out-frame mil-p-40-40">
                <div class="swiper mil-relative">
                    <div class="swiper-container mil-team mil-up">
                        <div class="swiper-wrapper">
                            <?php while( $teamQuery->have_posts() ): ?>
                                <?php $teamQuery->the_post();?>
                                <div class="swiper-slide">
                                    <div class="mil-team-card mil-up">
                                        <div class="mil-portrait mil-mb-30">
                                            <img src="<?php the_post_thumbnail_url(); ?>" alt="portrait">
                                        </div>
                                        <h5 class="mil-mb-15">
                                            <?php the_title(); ?>
                                        </h5>
                                        <p class="mil-text-xs mil-soft">
                                            <?= get_field('position'); ?>
                                        </p>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                            <?php wp_reset_postdata(); ?>
                        </div>
                    </div>
                    <div class="mil-slider-nav-1">
                        <div class="mil-testi-prev"></div>
                        <div class="mil-testi-next"></div>
                    </div>
                    <div class="mil-testi-pagination mil-up"></div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>