<?php
$terms = get_terms([
    'taxonomy'   => 'service-category',
    'hide_empty' => false,
    'order' => 'ASC',
    'orderby' => 'ID'
]);
$first = true;
?>

<section class="mil-faq mil-p-80-80">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8">
                <div class="mil-text-center">
                    <h2 class="mil-mb-30 mil-up">
                        <?php pll_e('What we offer');?>
                    </h2>
                </div>
                <?php foreach ($terms as $category): ?>
                    <div class="mil-accordion">
                        <div class="mil-accordion-group mil-up">
                            <div class="mil-accordion-menu" <?php if($first):?> data-opened-load="true" <?php endif; $first = false; ?> >
                                <h3>
                                    <?= $category->name; ?>
                                </h3>
                                <div class="mil-accordion-icon mil-dark"><i class="fas fa-chevron-up"></i></div>
                            </div>
                            <div class="mil-accordion-content">
                                <div class="mil-text-m mil-soft mil-mb-20">
                                    <?= get_field('description', $category->taxonomy . '_' . $category->term_id)?>
                                </div>
                                <?php
                                $serviceQuery = new WP_Query([
                                    'post_type' => 'service',
                                    'order' => 'DESC',
                                    'orderby' => 'ID',
                                    'tax_query' => [
                                        [
                                            'taxonomy' => 'service-category',
                                            'field' => 'term_id',
                                            'terms' => $category->term_id,
                                        ]
                                    ],
                                ]);
                                ?>
                                <?php if( $serviceQuery->have_posts() ): ?>
                                    <?php while( $serviceQuery->have_posts() ): ?>
                                        <?php $serviceQuery->the_post();?>
                                        <h5>
                                            <?php the_title(); ?>
                                        </h5>
                                    <?php endwhile; ?>
                                    <?php wp_reset_postdata(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>