<?php
    $terms = get_terms([
        'taxonomy'   => 'service-category',
        'hide_empty' => false,
        'order' => 'ASC',
        'orderby' => 'ID'
    ]);

//    $current_lang = pll_current_language();
//    if ($current_lang == 'uk') {
//        $urlServicesPage = get_permalink(get_page_by_path('poslugy'));
//    }
//    else {
//        $urlServicesPage = get_permalink(get_page_by_path('services'));
//    }
?>
<section class="mil-features mil-p-80-0">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <h2 class="mil-mb-60 mil-text-center mil-up">
                    <?php pll_e('Directions');?>
                </h2>
            </div>
        </div>
    </div>
</section>
<?php foreach ($terms as $index => $category): ?>
    <section class="mil-features mil-p-40-40">
        <div class="container">
            <div class="row justify-content-between align-items-center mil-gap-40 <?= $index % 2 !== 0 ? 'flex-sm-row-reverse' : '' ?>">
                <div class="col-xl-5">
                    <h3 class="h4 mil-mb-20 mil-up">
                        <?= $category->name; ?>
                    </h3>
                    <div class="mil-text-m mil-soft mil-mb-30 mil-up">
                        <?= get_field('description', $category->taxonomy . '_' . $category->term_id); ?>
                    </div>
                    <div class="mil-up">
                        <a href="<?= get_field('page_link', $category->taxonomy . '_' . $category->term_id); ?>" class="mil-btn mil-button-transform mil-m mil-add-arrow">
                            <?php pll_e('More Information');?>
                        </a>
                    </div>
                </div>
                <div class="col-xl-6">
                    <img src="<?= get_field('image', $category->taxonomy . '_' . $category->term_id); ?>" alt="image" class="mil-up mx-auto">
                </div>
            </div>
        </div>
    </section>
<?php endforeach; ?>