<?php
$availableLangs = pll_the_languages(['raw' => 1]);
$currentSlug = pll_current_language();
$currentLang = $availableLangs[$currentSlug];
?>

<div class="mil-dropdown mil-lang-switch">
    <button class="mil-btn mil-transp mil-dropdown-toggle" type="button">
        <img src='<?= get_stylesheet_directory_uri().'/resources/img/flags/'.$currentLang['slug'].'.svg' ?>' width="32px" alt='<?= $currentLang['name'] ?>'>
    </button>
    <ul>
        <?php foreach ($availableLangs as $lang): ?>
            <?php if($lang['slug'] !== $currentSlug):?>
                <li>
                    <a href="<?= $lang['url'] ?>">
                        <img src='<?= get_stylesheet_directory_uri().'/resources/img/flags/'.$lang['slug'].'.svg' ?>' width="32px" alt='<?= $lang['name'] ?>'>
                    </a>
                </li>
            <?php endif; ?>
        <?php endforeach;?>
    </ul>
</div>
