<?php
    $slides = get_field('slides');
    $slidesCount = 0;
    if ($slides) {
        $slidesCount = count($slides);
    }
?>
<?php if($slidesCount > 1): ?>
    <section class="mil-banner mil-dissolve">
        <div class="container">
            <div class="swiper swiper--wide mil-relative">
                <div class="swiper-container mil-hero mil-up">
                    <div class="swiper-wrapper">
                        <?php foreach ($slides as $slide): ?>
                            <div class="swiper-slide">
                                <div class="row align-items-center">
                                    <div class="col-xl-6">
                                        <div class="mil-banner-text">
                                            <h1 class="mil-display mil-text-gradient-3 mil-mb-20">
                                                <?= $slide['title'];?>
                                            </h1>
                                            <div class="mil-text-gradient-2 mil-mb-40">
                                                <?= $slide['description'];?>
                                            </div>
                                            <?php if (!empty($slide['button_text'])): ?>
                                                <div class="mil-buttons-frame">
                                                    <button type="button" class="mil-btn mil-md mil-add-arrow scroll-to"
                                                        <?php if (empty($slide['button_link'])): ?>
                                                            data-target="cta-section"
                                                        <?php else: ?>
                                                            onclick="location.href='<?= $slide['button_link']; ?>'"
                                                        <?php endif; ?>
                                                    >
                                                        <?= $slide['button_text']; ?>
                                                    </button>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="mil-banner-img">
                                            <img src="<?= $slide['image']; ?>" alt="banner">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="mil-slider-nav-1 mil-slider-nav-1--wide">
                    <div class="mil-testi-prev"></div>
                    <div class="mil-testi-next"></div>
                </div>
            </div>
        </div>
    </section>
<?php elseif($slidesCount > 0): ?>
    <section class="mil-banner mil-dissolve">
        <div class="container">
            <?php $slide = reset($slides); ?>
            <div class="row align-items-center">
                <div class="col-xl-6">
                    <div class="mil-banner-text">
                        <h1 class="mil-display mil-text-gradient-3 mil-mb-20">
                            <?= $slide['title'];?>
                        </h1>
                        <div class="mil-text-gradient-2 mil-mb-40">
                            <?= $slide['description'];?>
                        </div>
                        <?php if (!empty($slide['button_text'])): ?>
                            <div class="mil-buttons-frame">
                                <button type="button" class="mil-btn mil-md mil-add-arrow
                                    <?php if (empty($slide['button_link'])): ?>
                                        scroll-to" data-target="cta-section"
                                    <?php else: ?>
                                        " onclick="location.href='<?= $slide['button_link']; ?>'"
                                    <?php endif; ?>
                                >
                                    <?= $slide['button_text']; ?>
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="mil-banner-img">
                        <img src="<?= $slide['image']; ?>" alt="banner">
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>