<?php
/**
 * ReduxFramework Config File
 * For full documentation, please visit: https://devs.redux.io/
 *
 * @package Redux Framework
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) ) {
    return;
}

// This is your option name where all the Redux data is stored.
$opt_name = 'rockpay_options';

// Uncomment to disable demo mode.
/* Redux::disable_demo(); */  // phpcs:ignore Squiz.PHP.CommentedOutCode

$dir = __DIR__ . DIRECTORY_SEPARATOR;

/*
 * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
 */

// Background Patterns Reader.
$sample_patterns_path = Redux_Core::$dir . '../sample/patterns/';
$sample_patterns_url  = Redux_Core::$url . '../sample/patterns/';
$sample_patterns      = array();

if ( is_dir( $sample_patterns_path ) ) {
    $sample_patterns_dir = opendir( $sample_patterns_path );

    if ( $sample_patterns_dir ) {

        // phpcs:ignore Generic.CodeAnalysis.AssignmentInCondition.FoundInWhileCondition
        while ( false !== ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) ) {
            if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                $name              = explode( '.', $sample_patterns_file );
                $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                $sample_patterns[] = array(
                    'alt' => $name,
                    'img' => $sample_patterns_url . $sample_patterns_file,
                );
            }
        }
    }
}

// Used to except HTML tags in description arguments where esc_html would remove.
$kses_exceptions = array(
    'a'      => array(
        'href' => array(),
    ),
    'strong' => array(),
    'br'     => array(),
    'code'   => array(),
);

/*
 * ---> BEGIN ARGUMENTS
 */

/**
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://devs.redux.io/core/arguments/
 */
$theme = wp_get_theme(); // For use with some settings. Not necessary.

// TYPICAL → Change these values as you need/desire.
$args = array(
    // This is where your data is stored in the database and also becomes your global variable name.
    'opt_name'                  => $opt_name,

    // Name that appears at the top of your panel.
    'display_name'              => $theme->get( 'Name' ),

    // Version that appears at the top of your panel.
    'display_version'           => $theme->get( 'Version' ),

    // Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only).
    'menu_type'                 => 'menu',

    // Show the sections below the admin menu item or not.
    'allow_sub_menu'            => true,

    // The text to appear in the admin menu.
    'menu_title'                => esc_html__( 'Rockpay', 'rockpay' ),

    // The text to appear on the page title.
    'page_title'                => esc_html__( 'Rockpay', 'rockpay' ),

    // Disable to create your own Google fonts loader.
    'disable_google_fonts_link' => false,

    // Show the panel pages on the admin bar.
    'admin_bar'                 => true,

    // Icon for the admin bar menu.
    'admin_bar_icon'            => 'dashicons-portfolio',

    // Priority for the admin bar menu.
    'admin_bar_priority'        => 50,

    // Sets a different name for your global variable other than the opt_name.
    'global_variable'           => $opt_name,

    // Show the time the page took to load, etc. (forced on while on localhost or when WP_DEBUG is enabled).
    'dev_mode'                  => true,

    // Enable basic customizer support.
    'customizer'                => true,

    // Allow the panel to open expanded.
    'open_expanded'             => false,

    // Disable the save warning when a user changes a field.
    'disable_save_warn'         => false,

    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_priority'             => 90,

    // For a full list of options, visit: https://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters.
    'page_parent'               => 'themes.php',

    // Permissions needed to access the options panel.
    'page_permissions'          => 'manage_options',

    // Specify a custom URL to an icon.
    'menu_icon'                 => '',

    // Force your panel to always open to a specific tab (by id).
    'last_tab'                  => '',

    // Icon displayed in the admin panel next to your menu_title.
    'page_icon'                 => 'icon-themes',

    // Page slug used to denote the panel, will be based off page title, then menu title, then opt_name if not provided.
    'page_slug'                 => $opt_name,

    // On load save the defaults to DB before user clicks save.
    'save_defaults'             => true,

    // Display the default value next to each field when not set to the default value.
    'default_show'              => false,

    // What to print by the field's title if the value shown is default.
    'default_mark'              => '*',

    // Shows the Import/Export panel when not used as a field.
    'show_import_export'        => true,

    // The time transients will expire when the 'database' arg is set.
    'transient_time'            => 60 * MINUTE_IN_SECONDS,

    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output.
    'output'                    => true,

    // Allows dynamic CSS to be generated for customizer and google fonts,
    // but stops the dynamic CSS from going to the page head.
    'output_tag'                => true,

    // Disable the footer credit of Redux. Please leave if you can help it.
    'footer_credit'             => '',

    // If you prefer not to use the CDN for ACE Editor.
    // You may download the Redux Vendor Support plugin to run locally or embed it in your code.
    'use_cdn'                   => true,

    // Set the theme of the option panel.  Use 'wp' to use a more modern style, default is classic.
    'admin_theme'               => 'wp',

    // Enable or disable flyout menus when hovering over a menu with submenus.
    'flyout_submenus'           => true,

    // Mode to display fonts (auto|block|swap|fallback|optional)
    // See: https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face/font-display.
    'font_display'              => 'swap',

    // HINTS.
    'hints'                     => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color'    => 'lightgray',
        'icon_size'     => 'normal',
        'tip_style'     => array(
            'color'   => 'red',
            'shadow'  => true,
            'rounded' => false,
            'style'   => '',
        ),
        'tip_position'  => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect'    => array(
            'show' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'mouseover',
            ),
            'hide' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'click mouseleave',
            ),
        ),
    ),

    // FUTURE → Not in use yet, but reserved or partially implemented.
    // Use at your own risk.
    // Possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'database'                  => '',
    'network_admin'             => true,
    'search'                    => true,
);

// SOCIAL ICONS → Set up custom links in the footer for quick links in your panel footer icons.
// PLEASE CHANGE THESE SETTINGS IN YOUR THEME BEFORE RELEASING YOUR PRODUCT!!
// If these are left unchanged, they will not display in your panel!
$args['share_icons'][] = array(
    'url'   => '//github.com/ReduxFramework/ReduxFramework',
    'title' => 'Visit us on GitHub',
    'icon'  => 'el el-github',
);
$args['share_icons'][] = array(
    'url'   => '//www.facebook.com/pages/Redux-Framework/243141545850368',
    'title' => 'Like us on Facebook',
    'icon'  => 'el el-facebook',
);
$args['share_icons'][] = array(
    'url'   => '//twitter.com/reduxframework',
    'title' => 'Follow us on Twitter',
    'icon'  => 'el el-twitter',
);
$args['share_icons'][] = array(
    'url'   => '//www.linkedin.com/company/redux-framework',
    'title' => 'Find us on LinkedIn',
    'icon'  => 'el el-linkedin',
);

Redux::set_args( $opt_name, $args );

/*
 * ---> END ARGUMENTS
 */

/*
 * ---> START SECTIONS
 */

// -> START Basic Fields
$languages = pll_languages_list();

$fields = [];

array_push($fields,
    array(
        'id'       => 'section-contact-start',
        'type'     => 'section',
        'title'    => esc_html__( 'Контактна інформація', 'rockpay' ),
        'indent'   => true,
    ),
    array(
        'id'       => 'lang_switch_enable',
        'type'     => 'checkbox',
        'title'    => __('Відображати перемикач мов', 'rockpay'),
        'subtitle' => esc_html__('Увімкніть/вимкніть відображення перемикача мов', 'rockpay'),
        'default'  => '1',
    ),
    array(
        'id'       => 'contact_phone1',
        'type'     => 'text',
        'title'    => __('Телефон 1: ', 'rockpay'),
        'default'  => '',
    ),
    array(
        'id'       => 'contact_phone2',
        'type'     => 'text',
        'title'    => __('Телефон 2: ', 'rockpay'),
        'default'  => '',
    ),
    array(
        'id'       => 'contact_email',
        'type'     => 'text',
        'title'    => __('Email: ', 'rockpay'),
        'validate' => 'email',
        'default'  => '',
    )
);

foreach ($languages as $lang) {
    $fields[] = [
        'id'       => 'address_' . $lang,
        'type'     => 'text',
        'title'    => __('Адреса для: ', 'rockpay') . strtoupper($lang),
        'default'  => '',
    ];
}

$fields[] = [
    'id'     => 'section-contact-end',
    'type'   => 'section',
    'indent' => false,
];

array_push($fields,
    array(
        'id'       => 'section-social-start',
        'type'     => 'section',
        'title'    => esc_html__( 'Соціальні мережі та мессенджери', 'rockpay' ),
        'indent'   => true,
    ),
    array(
        'id'       => 'social_buttons_enable',
        'type'     => 'checkbox',
        'title'    => __('Відображати соціальні мережі та мессенджери', 'rockpay'),
        'subtitle' => esc_html__('Увімкніть/вимкніть відображення кнопок соціальних мереж на сайті', 'rockpay'),
        'default'  => '1',
    ),
    array(
        'id'       => 'social_linkedin',
        'type'     => 'text',
        'title'    => __('Linkedin: ', 'rockpay'),
        'subtitle'     => esc_html__('Вкажіть лінк до вашої сторінки на Linkedin', 'rockpay'),
        'default'  => '',
    ),
    array(
        'id'       => 'social_facebook',
        'type'     => 'text',
        'title'    => __('Facebook: ', 'rockpay'),
        'subtitle'     => esc_html__('Вкажіть лінк до вашої сторінки на Facebook', 'rockpay'),
        'default'  => '',
    ),
    array(
        'id'       => 'social_instagram',
        'type'     => 'text',
        'title'    => __('Instagram: ', 'rockpay'),
        'subtitle' => esc_html__('Вкажіть лінк до вашої сторінки на Instagram', 'rockpay'),
        'default'  => '',
    ),
    array(
        'id'       => 'social_telegram',
        'type'     => 'text',
        'title'    => __('Telegram: ', 'rockpay'),
        'subtitle' => esc_html__('Вкажіть лінк на ваш Telegram', 'rockpay'),
        'default'  => '',
    ),
    array(
        'id'       => 'social_viber',
        'type'     => 'text',
        'title'    => __('Viber: ', 'rockpay'),
        'subtitle' => esc_html__('Вкажіть лінк на ваш Viber', 'rockpay'),
        'default'  => '',
    ),
    array(
        'id'     => 'section-social-end',
        'type'   => 'section',
        'indent' => false,
    )
);

array_push($fields,
    array(
        'id'       => 'section-cta-start',
        'type'     => 'section',
        'title'    => esc_html__( 'Налаштування блоку CTA', 'rockpay' ),
        'indent'   => true,
    ),
    array(
        'id'           => 'cta_icon',
        'type'         => 'media',
        'url'          => true,
        'title'        => esc_html__( 'Зображення для блоку CTA', 'rockpay' ),
        'compiler'     => 'true',
        'desc'         => esc_html__( 'Завантажте зображення для блоку CTA.', 'rockpay' ),
        //'preview_size' => 'full',
    ),
    array(
        'id'     => 'section-cta-end',
        'type'   => 'section',
        'indent' => false,
    )
);

$fields[] = array(
    'id'       => 'contact_map',
    'type'     => 'textarea',
    'title'    => esc_html__( 'Мапа', 'rockpay' ),
    'subtitle' => esc_html__( 'Код мапи для відображення на сторінці контактів', 'rockpay' ),
    'desc'     => esc_html__( 'Вставьте код, який ви отримали з google map.', 'rockpay' ),
);

Redux::set_section(
    $opt_name,
    array(
        'title'            => esc_html__( 'Контакти', 'rockpay' ),
        'id'               => 'сontact_info',
        'desc'             => esc_html__( 'Тут можна додати контактну інформацію', 'rockpay' ),
        'icon'             => 'el el-home',
        'customizer_width' => '400px',
        'fields'           => $fields,
    )
);

Redux::set_section(
    $opt_name,
    array(
        'title'     => esc_html__('Партнери', 'rockpay'),
        'icon'      => 'el-icon-briefcase',
        'fields'    => array(
            array(
                'id'          => 'partner_logos',
                'type'        => 'repeater',
                'title'       => esc_html__('Логотипи', 'rockpay'),
                'full_width'  => true,
                //'item_name'   => '',
                'group_values' => true,
                'sortable'    => true,
                //'active'      => false,
                //'collapsible' => false,
                'fields'      => array(
                    array(
                        'id'          => 'partner_title',
                        'type'        => 'text',
                        'placeholder' => esc_html__( 'Назва Партнера', 'rockpay' ),
                    ),
                    array(
                        'id'           => 'partner_media',
                        'type'         => 'media',
                        'url'          => true,
                        'title'        => esc_html__( 'Логотип', 'rockpay' ),
                        'compiler'     => 'true',
                        'desc'         => esc_html__( 'Завантажте логотип партнера.', 'rockpay' ),
                        //'preview_size' => 'full',
                    ),
                ),
            ),
        ),
    )
);

Redux::set_section(
    $opt_name,
    array(
        'title'     => esc_html__('Переваги', 'rockpay'),
        'icon'      => 'el-icon-star',
        'fields'    => array(
            array(
                'id'          => 'advantages',
                'type'        => 'repeater',
                'title'       => esc_html__('Переваги', 'rockpay'),
                'full_width'  => true,
                'group_values' => true,
                'sortable'    => true,
                'fields'      => array(
                    array(
                        'id'          => 'advantage_title',
                        'type'        => 'text',
                        'placeholder' => esc_html__( 'Перевага', 'rockpay' ),
                    ),
                    array(
                        'id'          => 'advantage_amount',
                        'type'        => 'text',
                        'placeholder' => esc_html__( 'Перевага у кількісному вираженні', 'rockpay' ),
                    ),
                    array(
                        'id'           => 'advantage_media',
                        'type'         => 'media',
                        'url'          => true,
                        'title'        => esc_html__( 'Іконка', 'rockpay' ),
                        'compiler'     => 'true',
                        'desc'         => esc_html__( 'Завантажте іконку переваги.', 'rockpay' ),
                    ),
                ),
            ),
        ),
    )
);

// -> START Editors.
//Redux::set_section(
//    $opt_name,
//    array(
//        'title'            => esc_html__( 'Editors', 'your-textdomain-here' ),
//        'id'               => 'editor',
//        'customizer_width' => '500px',
//        'icon'             => 'el el-edit',
//    )
//);
//
//require_once Redux_Core::$dir . '../sample/sections/editors/wordpress-editor.php';
//require_once Redux_Core::$dir . '../sample/sections/editors/ace-editor.php';

// -> START Media Uploads.
//Redux::set_section(
//    $opt_name,
//    array(
//        'title' => esc_html__( 'Media Uploads', 'your-textdomain-here' ),
//        'id'    => 'media',
//        'icon'  => 'el el-picture',
//    )
//);
//
//require_once Redux_Core::$dir . '../sample/sections/media-uploads/gallery.php';
//require_once Redux_Core::$dir . '../sample/sections/media-uploads/media.php';
//require_once Redux_Core::$dir . '../sample/sections/media-uploads/multi-media.php';
//require_once Redux_Core::$dir . '../sample/sections/media-uploads/slides.php';

// → START Switch & Button Set.
//Redux::set_section(
//    $opt_name,
//    array(
//        'title' => esc_html__( 'Switch / Button Set', 'your-textdomain-here' ),
//        'id'    => 'switch_buttonset',
//        'icon'  => 'el el-cogs',
//    )
//);
//
//require_once Redux_Core::$dir . '../sample/sections/switch-button/button-set.php';
//require_once Redux_Core::$dir . '../sample/sections/switch-button/switch.php';

// -> START Additional Types.
//Redux::set_section(
//    $opt_name,
//    array(
//        'title' => esc_html__( 'Additional Types', 'your-textdomain-here' ),
//        'id'    => 'additional',
//        'icon'  => 'el el-magic',
//    )
//);
//
//require_once Redux_Core::$dir . '../sample/sections/additional-types/date.php';
//require_once Redux_Core::$dir . '../sample/sections/additional-types/date-time-picker.php';
//require_once Redux_Core::$dir . '../sample/sections/additional-types/sorter.php';
//require_once Redux_Core::$dir . '../sample/sections/additional-types/raw.php';

//Redux::set_section(
//    $opt_name,
//    array(
//        'title' => esc_html__( 'Advanced Features', 'your-textdomain-here' ),
//        'icon'  => 'el el-thumbs-up',
//    )
//);
//
//require_once Redux_Core::$dir . '../sample/sections/advanced-features/callback.php';
//
//// -> START Validation.
//require_once Redux_Core::$dir . '../sample/sections/advanced-features/field-validation.php';
//
//// -> START Sanitizing.
//require_once Redux_Core::$dir . '../sample/sections/advanced-features/field-sanitizing.php';
//
//// -> START Required.
//require_once Redux_Core::$dir . '../sample/sections/advanced-features/field-required-linking.php';
//
//require_once Redux_Core::$dir . '../sample/sections/advanced-features/wpml-integration.php';

// -> START Extensions.
//Redux::set_section(
//    $opt_name,
//    array(
//        'title' => esc_html__( 'Redux Extensions', 'your-textdomain-here' ),
//        'id'    => 'redux-extensions',
//        'icon'  => 'el el-redux',
//        'class' => 'pro_highlight',
//        'desc'  => esc_html__( 'For full documentation on this field, visit: ', 'your-textdomain-here' ) . '<a href="https://devs.redux.io/core-extensions/" target="_blank">https://devs.redux.io/core-extensions/</a>',
//    )
//);
//
//require_once Redux_Core::$dir . '../sample/sections/extensions/accordion.php';
////require_once Redux_Core::$dir . '../sample/sections/extensions/color-scheme.php';
////require_once Redux_Core::$dir . '../sample/sections/extensions/custom-fonts.php';
////require_once Redux_Core::$dir . '../sample/sections/extensions/google-maps.php';
////require_once Redux_Core::$dir . '../sample/sections/extensions/icon-select.php';
//require_once Redux_Core::$dir . '../sample/sections/extensions/js-button.php';
//require_once Redux_Core::$dir . '../sample/sections/extensions/repeater.php';
////require_once Redux_Core::$dir . '../sample/sections/extensions/search.php';
//require_once Redux_Core::$dir . '../sample/sections/extensions/shortcodes.php';
//require_once Redux_Core::$dir . '../sample/sections/extensions/social-profiles.php';
//require_once Redux_Core::$dir . '../sample/sections/extensions/tabbed.php';
//require_once Redux_Core::$dir . '../sample/sections/extensions/widget-areas.php';
//require_once Redux_Core::$dir . '../sample/sections/extensions/taxonomy.php';
//require_once Redux_Core::$dir . '../sample/sections/extensions/users.php';


//Redux::set_section(
//    $opt_name,
//    array(
//        'icon'            => 'el el-list-alt',
//        'title'           => esc_html__( 'Customizer Only', 'your-textdomain-here' ),
//        'desc'            => '<p class="description">' . esc_html__( 'This Section should be visible only in Customizer', 'your-textdomain-here' ) . '</p>',
//        'customizer_only' => true,
//        'fields'          => array(
//            array(
//                'id'              => 'opt-customizer-only',
//                'type'            => 'select',
//                'title'           => esc_html__( 'Customizer Only Option', 'your-textdomain-here' ),
//                'subtitle'        => esc_html__( 'The subtitle is NOT visible in customizer', 'your-textdomain-here' ),
//                'desc'            => esc_html__( 'The field desc is NOT visible in customizer.', 'your-textdomain-here' ),
//                'customizer_only' => true,
//                'options'         => array(
//                    '1' => esc_html__( 'Opt 1', 'your-textdomain-here' ),
//                    '2' => esc_html__( 'Opt 2', 'your-textdomain-here' ),
//                    '3' => esc_html__( 'Opt 3', 'your-textdomain-here' ),
//                ),
//                'default'         => '2',
//            ),
//        ),
//    )
//);

/*
 * <--- END SECTIONS
 */