<?php
/**
 * Gather all bits and pieces together.
 * If you end up having multiple post types, taxonomies,
 * hooks and functions - please split those to their
 * own files under /inc and just require here.
 *
 * @package rockpay
 */

error_reporting(E_ERROR | E_PARSE);

class Rockpay_Menu_Walker extends Walker_Nav_Menu {
    public function start_el( &$output, $data_object, $depth = 0, $args = null, $current_object_id = 0 ) {
        $menu_item = $data_object;

        if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
            $t = '';
            $n = '';
        } else {
            $t = "\t";
            $n = "\n";
        }
        $indent = ( $depth ) ? str_repeat( $t, $depth ) : '';
        $args = apply_filters( 'nav_menu_item_args', $args, $menu_item, $depth );
        $li_atts = array();
        $li_atts['class'] = $menu_item->current ? 'mil-active' : '';
        if ($args->walker->has_children) {
            $li_atts['class'] .= ' mil-has-children';
        }
        $li_atts = apply_filters( 'nav_menu_item_attributes', $li_atts, $menu_item, $args, $depth );
        $li_attributes = $this->build_atts( $li_atts );

        $output .= $indent . '<li' . $li_attributes . '>';

        $atts           = array();
        $atts['title']  = ! empty( $menu_item->attr_title ) ? $menu_item->attr_title : '';
        $atts['target'] = ! empty( $menu_item->target ) ? $menu_item->target : '';
        if ( '_blank' === $menu_item->target && empty( $menu_item->xfn ) ) {
            $atts['rel'] = 'noopener';
        } else {
            $atts['rel'] = $menu_item->xfn;
        }

        if ( ! empty( $menu_item->url ) ) {
            if ( get_privacy_policy_url() === $menu_item->url ) {
                $atts['rel'] = empty( $atts['rel'] ) ? 'privacy-policy' : $atts['rel'] . ' privacy-policy';
            }

            $atts['href'] = $menu_item->url;
        } else {
            $atts['href'] = '';
        }

        $atts['aria-current'] = $menu_item->current ? 'page' : '';

        $atts       = apply_filters( 'nav_menu_link_attributes', $atts, $menu_item, $args, $depth );
        $attributes = $this->build_atts( $atts );
        $title = apply_filters( 'the_title', $menu_item->title, $menu_item->ID );
        $title = apply_filters( 'nav_menu_item_title', $title, $menu_item, $args, $depth );

        $item_output  = $args->before;
        $item_output .= '<a' . $attributes . '>';
        $item_output .= $args->link_before . $title . $args->link_after;
        $item_output .= '</a>';
        $item_output .= $args->after;
        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $menu_item, $depth, $args );
    }

}
require_once get_template_directory() . '/inc/redux-options.php';

function rockpay_register_menus() {
    register_nav_menus(
        array(
            'header-menu' => __( 'Header Menu', 'rockpay'),
            'footer-menu' => __('Footer Menu', 'rockpay'),
            'footer-menu-services' => __('Footer Menu Services', 'rockpay')
        )
    );
}
add_action( 'init', 'rockpay_register_menus' );

function rockpay_remove_customizer_options( $wp_customize ) {
    $wp_customize->remove_section( 'static_front_page' );
    $wp_customize->remove_section( 'themes');
}
add_action( 'customize_register', 'rockpay_remove_customizer_options', 30 );

add_filter( 'show_admin_bar', '__return_false' );

function rockpay_get_the_menu () {
    $primaryMenu = array(
        'theme_location'  => 'header-menu',
        'container'       => '',
        'container_class' => false,
        'container_id'    => '',
        'menu_class'      => '',
        'menu_id'         => '',
        'echo'            => true,
        'walker'          => new Rockpay_Menu_Walker(),
    );
    return wp_nav_menu( $primaryMenu );
}
function rockpay_load_theme_textdomain() {
    load_theme_textdomain( 'rockpay', get_template_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'rockpay_load_theme_textdomain' );


function rockpay_allowed_block_types( $allowed_block_types, $block_editor_context ) {
    $allowed_block_types = array(
        'core/heading',
        'core/image',
        'core/list',
        'core/list-item',
        'core/paragraph',
    );
    return $allowed_block_types;
}
add_filter( 'allowed_block_types_all', 'rockpay_allowed_block_types', 10, 2 );

add_theme_support( 'title-tag' );

add_filter('wpcf7_autop_or_not', '__return_false');

add_theme_support( 'post-thumbnails' );

function rockpay_breadcrumbs(){
    $page_num = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    echo '<ul class="mil-breadcrumbs mil-center">';
    if( is_front_page() ){
        if( $page_num > 1 ) {
            echo '<li><a href="' . site_url() . '">'.__('Home', 'rockpay').'</a></li>';
        }

    } else {
        echo '<li><a href="' . site_url() . '">'.__('Home', 'rockpay').'</a></li>';
        if( is_single() ){
//            if('product' === get_post_type()) {
//                global $post;
//
//                $terms = get_the_terms( $post->ID, 'product-category' );
//                $current_term = reset($terms);
//                if ($current_term->parent) {
//                    echo str_replace('<li></li>', '','<li>'.get_term_parents_list($current_term->parent, 'product-category', array('separator' => '</li><li>')) . '</li>');
//                }
//                echo'<li><a href="' . get_term_link( $current_term ) . '">' . $current_term->name . '</a></li>';
//            }
            echo '<li><a>'.get_the_title().'</a></li>';
        } elseif ( is_page() ){
            global $post;
            if ( $post->post_parent ) {
                $parent_id  = $post->post_parent;
                $breadcrumbs = array();
                while ( $parent_id ) {
                    $page = get_post( $parent_id );
                    $breadcrumbs[] = '<li><a href="' . get_permalink( $page->ID ) . '">' . get_the_title( $page->ID ) . '</a></li>';
                    $parent_id = $page->post_parent;
                }
                echo join( '', array_reverse( $breadcrumbs ) );
            }
            echo '<li><a>'.get_the_title().'</a></li>';
        } elseif ( is_category() ) {
            $current_cat = get_queried_object();
            if( $current_cat->parent ) {
                echo '<li>'.get_category_parents( $current_cat->parent, true, '</li><li>' ).'</li>';
            }
            echo '<li>';
            single_cat_title();
            echo '</li>';
        } elseif( is_tag() ) {
            echo '<li>';
            single_tag_title();
            echo '</li>';
        } elseif ( is_day() ) {
            echo '<li><a href="' . get_year_link( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . '</a></li>';
            echo '<li><a href="' . get_month_link( get_the_time( 'Y' ), get_the_time( 'm' ) ) . '">' . get_the_time( 'F' ) . '</a></li>';
            echo '<li><a>'.get_the_time('d').'</a></li>';

        } elseif ( is_month() ) {

            echo '<li><a href="' . get_year_link( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . '</a></li>';
            echo '<li><a>'.get_the_time('F').'</a></li>';

        } elseif ( is_year() ) {
            echo '<li><a>'.get_the_time('Y').'</a></li>';
        } elseif ( is_author() ) {
            global $author;
            $userdata = get_userdata( $author );
            echo '<li><a>'.__('Published by', 'rockpay'). $userdata->display_name.'</a></li>';
        }
        elseif( is_tax('product-category') ) {
            $current_term = get_queried_object();
            if ($current_term->parent) {
                echo str_replace('<li></li>', '','<li>'.get_term_parents_list($current_term->parent, 'product-category', array('separator' => '</li><li>')) . '</li>');
            }
            echo '<li>';
            single_term_title();
            echo '</li>';
        }
        elseif ( is_404() ) {
            echo '<li><a>'.__('Error 404', 'rockpay').'</a></li>';
        }
        echo '</ul>';
    }
}

function rockpay_pagination($wp_query = null) {
    if(is_null($wp_query)) {
        global $wp_query;
    }
    if ( $wp_query->max_num_pages <= 1 ) return;

    $big = 999999999;
    $pages = paginate_links( array(
        'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
        'current' => max( 1, get_query_var('paged') ),
        'total' => $wp_query->max_num_pages,
        'type'  => 'array',
        'format' => '?paged=%#%',
        'prev_text' => '<i class="ti-arrow-left"></i> '.pll__('Prev'),
        'next_text' => pll__('Next').' <i class="ti-arrow-right"></i>'
    ) );
    if( is_array( $pages ) ) {
        echo '<ul class="pagination justify-content-center">';
        foreach ( $pages as $page ) {
            echo str_contains($page, 'aria-current') ? '<li class="page-item active">' : '<li class="page-item">';
            echo str_replace('page-numbers', 'page-link', $page);
            echo "</li>";
        }
        echo '</ul>';
    }
}

function rockpay_menu_classes($classes, $item, $args) {
    if ($args->theme_location == 'footer-menu' || $args->theme_location == 'footer-menu-services') {
        $classes[] = 'mil-text-m mil-soft mil-mb-15';
    }
    return $classes;
}
add_filter('nav_menu_css_class', 'rockpay_menu_classes', 10, 3);



function remove_service_category_description() {
    echo '<style>
        body.taxonomy-service-category .term-description-wrap {
            display:none;
        }
  </style>';
}

add_action('admin_head', 'remove_service_category_description');

function add_taxonomy_filter() {
    global $typenow;
    if ($typenow == 'service') {
       $taxonomy = 'service-category'; // Указываем кастомную таксономию
       $taxonomy_obj = get_taxonomy($taxonomy);

        wp_dropdown_categories(array(
            'show_option_all' => __('Все ' . $taxonomy_obj->label),
            'taxonomy'        => $taxonomy,
            'name'            => $taxonomy,
            'orderby'         => 'name',
            'selected'        => isset($_GET[$taxonomy]) ? $_GET[$taxonomy] : '',
            'value_field'     => 'slug',
            'hierarchical'    => true,
            'show_count'      => true,
            'hide_empty'      => true,
        ));
    }
}

add_action('restrict_manage_posts', 'add_taxonomy_filter');