<?php
/**
 * Template for displaying the footer
 */


global $rockpay_options;
?>
                <footer class="mil-footer-with-bg mil-p-160-0">
                    <div class="container">
                        <div class="row justify-content-between">
                            <div class="col-xl-4 mil-mb-60">
                                <?php get_template_part('template-parts/footer/logo'); ?>
                                <?php if (isset($rockpay_options['social_buttons_enable']) && $rockpay_options['social_buttons_enable'] == '1'): ?>
                                    <?php get_template_part('template-parts/footer/socials'); ?>
                                <?php endif; ?>
                                <?php get_template_part('template-parts/footer/contacts'); ?>
                            </div>
                            <div class="col-xl-3 mil-mb-60">
                                <?php get_template_part('template-parts/footer/nav'); ?>
                            </div>
                            <div class="col-xl-3 mil-mb-60">
                                <?php get_template_part('template-parts/footer/nav-services'); ?>
                            </div>
                        </div>
                        <div class="mil-footer-bottom">
                            <div class="row">
                                <div class="col-xl-6">
                                    <p class="mil-text-s mil-soft">
                                        © <?= date("Y"); ?> <?php bloginfo('name');?>
                                    </p>
                                </div>
                                <div class="col-xl-6">
                                    <div class="row align-items-end">
                                        <div class="col">
                                            <a href="#" class="mil-text-s mil-soft">
                                                <?php pll_e('Terms & Conditions'); ?>
                                            </a>
                                        </div>
                                        <div class="col">
                                            <a href="#" class="mil-text-s mil-soft">
                                                <?php pll_e('Privacy Policy'); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
        <?php get_template_part('template-parts/footer/modal'); ?>
        <script src="<?= get_stylesheet_directory_uri(); ?>/resources/js/plugins/jquery.min.js"></script>
        <script src="<?= get_stylesheet_directory_uri(); ?>/resources/js/plugins/swiper.min.js"></script>
        <script src="<?= get_stylesheet_directory_uri(); ?>/resources/js/plugins/gsap.min.js"></script>
        <script src="<?= get_stylesheet_directory_uri(); ?>/resources/js/plugins/ScrollSmoother.min.js"></script>
        <script src="<?= get_stylesheet_directory_uri(); ?>/resources/js/plugins/ScrollTrigger.min.js"></script>
        <script src="<?= get_stylesheet_directory_uri(); ?>/resources/js/plugins/ScrollTo.min.js"></script>
        <script src="<?= get_stylesheet_directory_uri(); ?>/resources/js/plugins/micromodal.min.js"></script>
        <script src="<?= get_stylesheet_directory_uri(); ?>/resources/js/main.js"></script>
        <?php wp_footer(); ?>
    </body>
</html>
